#include<stdio.h>
#include<dirent.h>
#include<unistd.h>
#include<string.h>
#include<sys/stat.h>

long dirsize(const char* dirname);

main(int argc, char *argv[])
{
	long total;
	char *result,*cwd;
	int tmp=0,cnt=0;

	if(argc<2)  {
		printf("Usage: dirsize DIRECTORY | -nosubdir\n");
		return;
	}
	total=dirsize(argv[1]);

	asprintf(&result, "%ld",total);
	
	if((tmp=strlen(result) % 3)!=0) {
		for(cnt=0;cnt<tmp;cnt++)
			printf("%c",result[cnt]);
		if(cnt<strlen(result))
			printf(",");
	}
	while(cnt < strlen(result)) {
		printf("%c",result[cnt]);
		++cnt;
		if(((cnt-tmp) % 3)==0 && cnt<strlen(result))
			printf(",");
	}
	printf("   bytes\n");
}

long dirsize(const char* dirname)
{
	long total=0;
	DIR *dir;
	struct dirent *mydirent;
	char *cwd,*tmp;
	struct stat filestat;
	int dodir=1;
	
	
	if(strcmp(dirname,"-nodir")==0) {
		dir=opendir(".");
		dodir=0;
	}
	else {
		if((dir=opendir(dirname))==NULL)  {
			printf("Opendir failed:  %s\n",dirname);
			exit();
		}
		chdir(dirname);
  }

	while((mydirent=readdir(dir))!=NULL)  {
		lstat(mydirent->d_name,&filestat);
		if(S_ISDIR(filestat.st_mode)==0 &&
		   S_ISREG(filestat.st_mode)==0 ||
		   strcmp(mydirent->d_name,".")==0 ||  		  
		   strcmp(mydirent->d_name,"..")==0)
		/*if(S_ISLNK(filestat.st_mode)!=0 ||
		   strcmp(mydirent->d_name,".")==0 ||  		  
		   strcmp(mydirent->d_name,"..")==0) 	*/
			continue; 		
		if(S_ISDIR(filestat.st_mode)!=0) {   	 	
			if(dodir)
				total+=dirsize(mydirent->d_name); 	 	 		
		}
		else   	
			total+=filestat.st_size; 	
	}
	chdir("..");
	closedir(dir);
	return total;
}


